#include <fcntl.h>
#include <ioLib.h>
#include <stdio.h>
#include <iostream.h>
#include <taskLib.h>
#include <assert.h> 

extern "C" void _vxMunch(int);

extern "C" {
#if 0
extern int printf (const char *fmt, ...);
extern void shell (int) __attribute__ ((noreturn));
extern void taskDeleteForce (int) __attribute__ ((noreturn));
extern int taskDelay (int);
extern int   taskSpawn (char *name, int priority, int options, int stackSize,
                     int (*entryPt) (int), int arg1, int arg2, int arg3,
                     int arg4, int arg5, int arg6, int arg7,
                     int arg8, int arg9, int arg10);
extern void ioTaskStdSet (int, int, int);
extern int open (const char *name, int flags, int mode);
#endif

#ifndef STACK_SIZE
#define STACK_SIZE 20000 /* BLEH! As seen hard-coded in taskLib.c */
#endif

/****************************************************************************/

void
exit (int code)
{
  _vxMunch(8);
  /*FIXME: We don't really want to include C++ by default do we?*/
  cout.flush ();
#if 1
  printf ("\n*** EXIT code %d\n", code);
#else
  printf ("value = %d = 0x%x\n",code,code); /* simulate vxworks return */
#endif
#if 0
  shell (1); /* restart vxworks shell */
#else

  taskDeleteForce (taskIdSelf ());
  // a: goto a;
#endif
}

/****************************************************************************/

void
_exit (int code)
{
  exit (code);
  // a: goto a;
}

void
abort ()
{
  _exit (4242);
  // a: goto a;
}

int main(int, char **, char **); 

int
__test_main2 (char *input_file, int argc, char **argv, char **envp)
{
  /* We need to give the shell a while to recover from spawning
   * us since we're running asynchronously ... In particular
   * the framework would like to see a prompt.
   */
  taskDelay (360);
  _vxMunch(1);
  if (input_file)
    {
      int input_fd;
      int value;
      if   (!(input_fd = open (input_file, 0, 0)))
	{
	  printf ("Can't open input_file: %s\n", input_file);
	  abort ();
	};
      /* Set stdin (this thread only) to input_fd */
      ioTaskStdSet (0, 0, input_fd);
      {
	filebuf *buf = new filebuf(0);
	istream *is = new istream(buf);
	cin = *is;
      }
      assert(cin.good()); // TEMPORARY
#if 0
      /* Set stderr (this thread only) to console - i.e "/dev/null" */
      ioTaskStdSet (0, 2, 3);
#endif
      value = main (argc, argv, envp);
      /* FIXME: This should be done in exit */
      close (input_fd);
      /* Why should we have to do this?? */
      //    ioTaskStdSet (0, 0, 3);
      exit (value);
    }
  
  exit (main (argc, argv, envp));
}

static char * __argv [2];
static int __argc;

/*__test_main (char *input_file, int argc, char **argv, char **envp)*/
/* If you change the interface of __test_main you'll need
* to make corresponding changes in vxworks.exp (proc vxworks_run).
*/
int
__test_main (char *arg1, char *input_file)
{
#define VX_FP_TASK 0x0008
  /*  printf ("__test_main (%s, %s)\n", (arg1) ? arg1 : "", (input_file) ? input_file : ""); */
  __argv[0] = "__test_main";
  if (arg1 != 0)
    {
      __argc = 2;
      __argv[1] = arg1; 
    }
  else
    {
      __argc = 1;
    }
  return  taskSpawn (0, 100, VX_FP_TASK, STACK_SIZE,
		     (int (*)(...)) __test_main2,
		     (int) input_file, __argc, (int) __argv,
		     0, 0, 0, 0, 0, 0, 0);
}

void
__assert (const char *msg)
{
  printf("%s\n", (char *) msg); /* print msg to error stream */
  abort ();
}

} /* extern "C" */
